
// Define pins:
#define trigPin  10
#define echoPin  5

// Define variables:
long duration;
int distance;
bool flag = true;
unsigned long previousMillis = 0;
const long interval = 1; //minutes to wait after a sound was made to check again if somebody is passing


#include <SPI.h>
#include <FreeStack.h>

//Add the SdFat Libraries
#include <SdFat.h>

//and the MP3 Shield Library
#include <vs1053_SdFat.h>

//Delete if Button not working; Just a little extra so I can check if the audio is working at anytime
#include <Bounce2.h> 
#define B_NEXT  A0
#define BUTTON_DEBOUNCE_PERIOD 20 //ms
Bounce b_Next  = Bounce();

// Below is not needed if interrupt driven. Safe to remove if not using.
#if defined(USE_MP3_REFILL_MEANS) && USE_MP3_REFILL_MEANS == USE_MP3_Timer1
  #include <TimerOne.h>
#elif defined(USE_MP3_REFILL_MEANS) && USE_MP3_REFILL_MEANS == USE_MP3_SimpleTimer
  #include <SimpleTimer.h>
#endif

/**
 * \brief Object instancing the SdFat library.
 *
 * principal object for handling all SdCard functions.
 */
SdFat sd;

/**
 * \brief Object instancing the vs1053 library.
 *
 * principal object for handling all the attributes, members and functions for the library.
 */
vs1053 MP3player;

void setup() {
  uint8_t result; //result code from some function as to be tested at later time.

  Serial.begin(115200);
  //Delete if ..
  pinMode(B_NEXT, INPUT_PULLUP);
  b_Next.attach(B_NEXT);
  b_Next.interval(BUTTON_DEBOUNCE_PERIOD);

   // Define inputs and outputs:
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);

  Serial.print(F("F_CPU = "));
  Serial.println(F_CPU);
  Serial.print(F("Free RAM = ")); // available in Version 1.0 F() bases the string to into Flash, to use less SRAM.
  Serial.print(FreeStack(), DEC);  // FreeStack() is provided by SdFat
  Serial.println(F(" Should be a base line of 1028, on ATmega328 when using INTx"));


  //Initialize the SdCard.
  if(!sd.begin(SD_SEL, SPI_FULL_SPEED)) sd.initErrorHalt();
  // depending upon your SdCard environment, SPI_HAVE_SPEED may work better.
  if(!sd.chdir("/")) sd.errorHalt("sd.chdir");

  //Initialize the MP3 Player Shield
  result = MP3player.begin();
  MP3player.setVolume(10,10);
  //check result, see readme for error codes.
  if(result != 0) {
    Serial.print(F("Error code: "));
    Serial.print(result);
    Serial.println(F(" when trying to start MP3 player"));
    if( result == 6 ) {
      Serial.println(F("Warning: patch file not found, skipping.")); // can be removed for space, if needed.
      Serial.println(F("Use the \"d\" command to verify SdCard can be read")); // can be removed for space, if needed.
    }
  }

#if defined(__BIOFEEDBACK_MEGA__) // or other reasons, of your choosing.
  // Typically not used by most shields, hence commented out.
  Serial.println(F("Applying ADMixer patch."));
  if(MP3player.ADMixerLoad("admxster.053") == 0) {
    Serial.println(F("Setting ADMixer Volume."));
    MP3player.ADMixerVol(-3);
  }
#endif
}

void loop() {
   unsigned long currentMillis = millis();
   unsigned long Minutes = ( currentMillis/1000 ) / 60;
   

  // Below is only needed if not interrupt driven. Safe to remove if not using.
#if defined(USE_MP3_REFILL_MEANS) \
    && ( (USE_MP3_REFILL_MEANS == USE_MP3_SimpleTimer) \
    ||   (USE_MP3_REFILL_MEANS == USE_MP3_Polled)      )

  MP3player.available();
#endif

  /**if(Serial.available()) {
    parse_menu(Serial.read()); // get command from serial input
  }**/
  delay(100);
  uint32_t  millis_prv;
  //----------------------  

  
  //Button function to test if sound can be heard
  //Delete if ..
  if (b_Next.update()) {
    if (b_Next.read() == LOW) {
      Serial.print(F("B_NEXT pressed, testing sound"));
      MP3player.SendSingleMIDInote();
    }
  }
  
  if(flag == true){
    int tracknumb = random(1, 6);

  // USSensor
  // Clear the trigPin by setting it LOW:
  digitalWrite(trigPin, LOW);
  delayMicroseconds(5);
  // Trigger the sensor by setting the trigPin high for 10 microseconds:
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);

  // Read the echoPin, pulseIn() returns the duration (length of the pulse) in microseconds:
  duration = pulseIn(echoPin, HIGH);
  // Calculate the distance:
  distance = duration * 0.034 / 2;

  // Print the distance on the Serial Monitor (Ctrl+Shift+M):
  Serial.print("Distance = ");
  Serial.print(distance);
  Serial.println(" cm");

  delay(50);


  //if-clause to check if someone is close but not already standing in front of 
  if((distance <= 200) && (distance >= 100)){
    //play sound and go to next sound
    //tell the MP3 Shield to play a track
    Serial.println("Someone walked by");
    //result = MP3player.playTrack(1);
    //maybe let him choose a track randomly between 1 and x
    
    Serial.println(tracknumb);
    MP3player.playTrack(tracknumb);

    //check result, see readme for error codes.
    /*if(result != 0) {
      Serial.print(F("Error code: "));
      Serial.print(result);
      Serial.println(F(" when trying to play track"));
    } else {

      Serial.println(F("Playing:"));

      //we can get track info by using the following functions and arguments
      //the functions will extract the requested information, and put it in the array we pass in
      MP3player.trackTitle((char*)&title);
      MP3player.trackArtist((char*)&artist);
      MP3player.trackAlbum((char*)&album);

      //print out the arrays of track information
      Serial.write((byte*)&title, 30);
      Serial.println();
      Serial.print(F("by:  "));
      Serial.write((byte*)&artist, 30);
      Serial.println();
      Serial.print(F("Album:  "));
      Serial.write((byte*)&album, 30);
      Serial.println();
    }*/
    //invert flag
    flag = false;
    Serial.println(flag);
    //set timer on current time
    previousMillis = Minutes;
    }
   }
   else if(flag == false){
    
    if (Minutes - previousMillis >= interval) {
      flag = true;
      Serial.println(flag);
    }
   }
    
}
